const condicionesambientales = "condiciones-ambientales-v1";
const assets = [
    "componentes/index/index.php",
    "componentes/analisis_rango_fechas/analisis_rango.php",
    "componentes/analisis_por_mes/analisis_mes.php",
    "css/estilos.css",
    "css/footable.standalone.css",
    "css/footable.standalone.min.css",
    "img/borrar.png",
    "img/Logo-Laboratorio.png",
    "js/footable.js",
    "js/footable.min.js",
    "js/script.js",
];

self.addEventListener('install', event => {
    event.waitUntil(
        caches.open(condicionesambientales)
            .then(cache => {
                return cache.addAll(assets);
            })
    );
});

self.addEventListener('fetch', event => {
    event.respondWith(
        caches.match(event.request)
            .then(response => {
                return response || fetch(event.request);
            })
    );
});

self.addEventListener('activate', event => {
    const cacheWhitelist = [condicionesambientales];
    event.waitUntil(
        caches.keys().then(cacheNames => {
            return Promise.all(
                cacheNames.map(cacheName => {
                    if (!cacheWhitelist.includes(cacheName)) {
                        return caches.delete(cacheName);
                    }
                })
            );
        })
    );
});

self.addEventListener('push', function(event) {
  const options = {
    body: 'Es hora de una notificación!',
    icon: 'Logo-Laboratorio.png',
  };
  event.waitUntil(
    self.registration.showNotification('Notificación Horaria', options)
  );
});