/* Service Worker */
if ("serviceWorker" in navigator) {
  window.addEventListener("load", function() {
    navigator.serviceWorker
    .register("../../serviceWorker.js")
    .then(res => console.log("Service worker registrado"))
    .catch(err => console.log("Service worker no se pudo registrar", err))
  })
}

/* Reloj y Fecha */
function mostrarReloj(){
  var datoshorario = new Date();
  var horas = datoshorario.getHours().toString().padStart(2, '0');
  var minutos = datoshorario.getMinutes().toString().padStart(2, '0');
  var segundos = datoshorario.getSeconds().toString().padStart(2, '0');
  ap = (horas < 12) ? " <span> am</span>" : " <span> pm</span>";
  horas = (horas === 0) ? 12 : horas;
  horas = (horas > 12) ? horas - 12 : horas;
  document.getElementById("hora").innerHTML = horas + ":" + minutos + ":" + segundos + " " + ap;

  var meses = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];
  var dias = ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'];
  var datodiames = dias[datoshorario.getDay()];
  var datodia = datoshorario.getDate();
  var datomes = meses[datoshorario.getMonth()];
  var datoanio = datoshorario.getFullYear();
  var date = datodiames+", "+datodia+" de "+datomes+" "+datoanio;
  document.getElementById("calendario").innerHTML = date;

  /* Mostrar alerta cada hora para ingresar nuevas temperaturas */
  if (minutos === '00' && segundos === '00') {
    navigator.serviceWorker.ready.then(function(registration) {
      registration.showNotification('!Recuerda!', {
          body: 'Tienes nuevas temperaturas por ingresar',
          icon: '../../img/mayun.png',
          url: ''
      });
  });
  }
}setInterval(mostrarReloj, 1000);

/* Notificaciónes */
Notification.requestPermission().then((permission) => {
  if (permission === 'granted') {
      console.log('Permiso de notificaciones concedido.');
  } else {
      console.log('Permiso de notificaciones denegado.');
  }
});

/* Información de pie de pagina */
document.getElementById('nosotros').addEventListener('click', function() {
  window.scrollTo({
    top: document.body.scrollHeight,
    behavior: 'smooth'
  });
});

/* Iniciar tooltips para mensajes de la tabla */
var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  tooltipTriggerList.forEach(function (tooltipTriggerEl) {
    new bootstrap.Tooltip(tooltipTriggerEl);
});

/* ------ MODALES PARA GUARDAR Y VISUALIZAR ------ */

/* Bonton para guardar datos ingresados */
$(document).ready(function(){
  $('#formularioguardar').on('submit', function(e){
    e.preventDefault();
    var tt1 = $('#tt1').val();
    var tt2 = $('#tt2').val();
    var tt3 = $('#tt3').val();
    var tt4 = $('#tt4').val();
    var tt5 = $('#tt5').val();
    var temperatura = $('#temperatura').val();
    var humedad = $('#humedad').val();
    var presion = $('#presion').val();

    $.ajax({
      url: '../guardar.php',
      type: 'POST',
      data: {tt1, tt2, tt3, tt4, tt5, temperatura, humedad, presion},
      success: function(response){
        Swal.fire({
          position: "center",
          icon: "success",
          title: "Datos guardados correctamente.",
          showConfirmButton: false,
          timer: 1500
        });
        document.getElementById("formularioguardar").reset();
        tabla_index();
      },
      error: function(){
        Swal.fire({
          icon: "error",
          title: "Error",
          text: "No fue posible guardar los datos.",
          showConfirmButton: false,
          timer: 1500
        });
      }
    });
  });
});
function guardar_datos(){}

/* Boton para guardar datos de análisis mes*/
$(document).ready(function(){
  $('#formularioanalisismes').on('submit', function(e){
    e.preventDefault();
    var nombre = $('#nombre').val();
    var cargo = $('#cargo').val();
    var fecha_analisis = $('#fecha_analisis').val();
    var analisis = $('#analisis').val();

    $.ajax({
      url: 'guardar_analisis_mes.php',
      type: 'POST',
      data: {nombre, cargo, fecha_analisis, analisis},
      success: function(response){
        Swal.fire({
          position: "center",
          icon: "success",
          title: "Análisis guardado correctamente",
          showConfirmButton: false,
          timer: 1500
        });
        document.getElementById("formularioanalisismes").reset();
        $('#modal_analisis_mes').modal('hide');
      },
      error: function(){
        Swal.fire({
          icon: "error",
          title: "Error",
          text: "No fue posible guardar el análisis",
          showConfirmButton: false,
          timer: 1500
        });
      }
    });
  });
});
function guardar_analisis_mes(){}

/* Boton para guardar datos de análisis por rango de fechas*/
$(document).ready(function(){
  $('#formularioanalisisrango').on('submit', function(e){
    e.preventDefault();
    var nombre = $('#nombre').val();
    var cargo = $('#cargo').val();
    var fecha_inicio = $('#fecha_inicio').val();
    var fecha_final = $('#fecha_final').val();
    var analisis = $('#analisis').val();

    $.ajax({
      url: 'guardar_analisis_rango.php',
      type: 'POST',
      data: {nombre, cargo, fecha_inicio, fecha_final, analisis},
      success: function(response){
        Swal.fire({
          position: "center",
          icon: "success",
          title: "Análisis guardado correctamente",
          showConfirmButton: false,
          timer: 1500
        });
        document.getElementById("formularioanalisisrango").reset();
        $('#modal_analisis_rango').modal('hide');
      },
      error: function(){
        Swal.fire({
          icon: "error",
          title: "Error",
          text: "No fue posible guardar el análisis",
          showConfirmButton: false,
          timer: 1500
        });
      }
    });
  });
});
function guardar_analisis_rango(){}

/* Guardar versiones */
$(document).ready(function(){
  $('#formularioversion').on('submit', function(e){
    e.preventDefault();
    var versiones = $('#versiones').val();
    var descripcion = $('#descripcion').val();

    $.ajax({
      url: '../versiones/guardar_version.php',
      type: 'POST',
      data: {versiones, descripcion},
      success: function(response){
        Swal.fire({
          position: "center",
          icon: "success",
          title: "Versión agregada correctamente",
          showConfirmButton: false,
          timer: 1500
        });
        document.getElementById("formularioversion").reset();
        $('#modal_versiones').modal('hide');
        mostrar_versiones();
      },
      error: function(){
        Swal.fire({
          icon: "error",
          title: "Error",
          text: "No fue posible guardar la versión",
          showConfirmButton: false,
          timer: 1500
        });
      }
    });
  });
});
function guardar_version(){}

/* Mostrar datos de la tabla de inicio */
function tabla_index(){
  $.ajax({
    url: 'tabla_index.php',
    type: 'GET',
    success: function(data){
      $('#datostemperaturas').html(data);
      calculamosdatos();
      colores();
      actualizargrafica();
    }
  });
}
$(document).ready(function(){
  tabla_index();
  /*setInterval(tabla_index, 5000);*/
});

/* Funcion para filtrar busqueda mes*/
function filtrar(){
  var mes_anio_busqueda = $('#mes_anio_busqueda').val();

  $.ajax({
    url: 'filtrar_mes.php',
    type: 'POST',
    data: {mes_anio_busqueda},
    success: function(response){
      $('#resultados_analisis').html(response);
      jQuery(function($){
        $('#resultados_analisis').footable({
        });
      });
    }
  });
}

/* Funcion para filtrar busqueda por rango de fechas*/
function filtrar_rango(){
  var busqueda_fecha_inicio = $('#busqueda_fecha_inicio').val();
  var busqueda_fecha_final = $('#busqueda_fecha_final').val();

  $.ajax({
    url: 'filtrar_rango.php',
    type: 'POST',
    data: {busqueda_fecha_inicio, busqueda_fecha_final},
    success: function(response){
      $('#resultados_analisis_rango').html(response);
      jQuery(function($){
        $('#resultados_analisis_rango').footable({
        });
      });
    }
  });
}

/* llamar datos de análisis por rangos de fechas*/
function buscar_analisis_rango_fechas(){
  tabla_analisis_rango_fechas();
}

/* Mostrar datos de la tabla de análisis por rango de fachas */
function tabla_analisis_rango_fechas(){
  var fecha_inicio = $('#fecha_inicio').val();
  var fecha_final = $('#fecha_final').val();

  $.ajax({
    url: 'tabla_analisis_rango.php',
    type: 'POST',
    data: {fecha_inicio, fecha_final},
    success: function(response){
      $('#datostemperaturas').html(response);
      calculamosdatos();
      colores();
      actualizargrafica();
    }
  });
}

/* Funcion para mostrar análisis de rango guardados */
function mostrar_analisis_rango(){
  $.ajax({
    url: 'ver_analisis_rango.php',
    type: 'GET',
    success: function(data){
      $('#resultados_analisis_rango').html(data);
      jQuery(function($){
        $('#resultados_analisis_rango').footable({
        });
      });
    }
  });
}

/* Análisis generados por mes */
function buscar_analisis_mes(){
  tabla_analisis_mes();
}

/* Mostrar datos de la tabla análisis mes */
function tabla_analisis_mes(){
var fecha_analisis = $('#fecha_analisis').val();

  $.ajax({
    url: 'tabla_analisis_mes.php',
    type: 'POST',
    data: {fecha_analisis},
    success: function(response){
      $('#datostemperaturas').html(response);
      calculamosdatos();
      colores();
      actualizargrafica();
    }
  });
}

/* Funcion para mostrar análisis del mes guardados */
function mostrar_analisis_mes(){
  $.ajax({
    url: 'ver_analisis_mes.php',
    type: 'GET',
    success: function(data){
      $('#resultados_analisis').html(data);
      jQuery(function($){
        $('#resultados_analisis').footable({
        });
      });
    }
  });
}

/* Mostrar versiones */
function mostrar_versiones(){
  $.ajax({
    url: '../versiones/tabla_versiones.php',
    type: 'GET',
    success: function(data){
      $('#versiones_guardadas').html(data);
        jQuery(function($){
          $('#versiones_guardadas').footable({
          });
      });
    }
  });
}

/* Apicamos movimiento al modal de creación de análisis y versiones*/
$('#modal_analisis_rango').draggable({ handle: ".modal-header" });
$("#modal_analisis_mes").draggable({ handle: ".modal-header" });
$("#modal_versiones").draggable({ handle: ".modal-header" });

/* BOTONES PARA ELIMINAR */
/* Funcion para eliminar datos de temperaturas*/   
function btn_borrar(txtID){
  Swal.fire({
    title: "¿Estás Seguro?",
    text: "No se podra recuperar este dato",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Eliminar",
    cancelButtonText: "Cancelar",
  }).then((result) => {
    if (result.isConfirmed){
      $.ajax({
        url: '../eliminar.php',
        type: 'POST',
        data: {txtID},
        success: function(response){
          Swal.fire({
            title: "Eliminado!",
            text: "El dato se elimino correctamente.",
            icon: "success",
            showConfirmButton: false,
            timer: 1500
          });
          tabla_index();
          tabla_analisis_mes();
          tabla_analisis_rango_fechas();
        }
      });
    }
  });
}

/* Borrar análisis mes */
function borrar_analisis_mes(txtID){
  Swal.fire({
    title: "¿Estás Seguro?",
    text: "No se podra recuperar este dato",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Eliminar",
    cancelButtonText: "Cancelar",
  }).then((result) => {
    if (result.isConfirmed){
      $.ajax({
        url: 'eliminar_analisis_mes.php',
        type: 'POST',
        data: {txtID},
        success: function(response){
          Swal.fire({
            title: "Eliminado!",
            text: "El dato se elimino correctamente.",
            icon: "success",
            showConfirmButton: false,
            timer: 1500
          });
          mostrar_analisis_mes();
        }
      });
    }
  });
}

/* Borrar análisis por rangos de fechas*/
function borrar_analisis_rango(txtID){
  Swal.fire({
    title: "¿Estás Seguro?",
    text: "No se podra recuperar este dato",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Eliminar",
    cancelButtonText: "Cancelar",
  }).then((result) => {
    if (result.isConfirmed){
      $.ajax({
        url: 'eliminar_analisis_rango.php',
        type: 'POST',
        data: {txtID},
        success: function(response){
          Swal.fire({
            title: "Eliminado!",
            text: "El dato se elimino correctamente.",
            icon: "success",
            showConfirmButton: false,
            timer: 1500
          });
          mostrar_analisis_rango();
        }
      });
    }
  });
}

/* CALCULOS, COLORES Y GRAFICAS DE LAS TABLAS */
/* Calcular y mostrar resultados de temperaturas en la tabla*/
function calculamosdatos(){
const table = document.getElementById("datostemperaturas");
const rows = table.rows;
let valores = [];

/* Recorrenos la tabla */
for (let i = 1; i < rows.length; i++){
let sum = 0;
let contador = 0;
const valor = rows[i].cells[0].textContent;
valores.push(parseFloat(valor, 10));

for (let j = 2; j <= 4; j++){
const cellValue = parseFloat(rows[i].cells[j].innerText);
  if (!isNaN(cellValue)){
    sum += cellValue;
    contador++;
  }
}

/* Calculamos Punto de rocio */
const dt = parseFloat(rows[i].cells[6].innerText);
const dh = parseFloat(rows[i].cells[7].innerText);
var total = Math.pow(dh/100, 1/8)*(112+0.9*dt)+(0.1*dt)-112;
rows[i].cells[9].innerText = total.toFixed(1) + "°C";

/* Calculamos Promedio */
const promedio = sum / contador;
rows[i].cells[10].innerText = promedio.toFixed(1) + "°C";

/* Tomamos datos de las temperaturas ingresadas (tt1-tt5) */
const tt1 = parseFloat(rows[i].cells[1].innerText);
const tt2 = parseFloat(rows[i].cells[2].innerText);
const tt3 = parseFloat(rows[i].cells[3].innerText);
const tt4 = parseFloat(rows[i].cells[4].innerText);
const tt5 = parseFloat(rows[i].cells[5].innerText);

/* Comparacion temperatura aire ensayo tt1 */
rows[i].cells[13].innerText = Math.abs((tt1 - tt2)).toFixed(2) + "°C";
rows[i].cells[14].innerText = Math.abs((tt1 - tt3)).toFixed(2) + "°C";
rows[i].cells[15].innerText = Math.abs((tt1 - tt4)).toFixed(2) + "°C";
rows[i].cells[16].innerText = Math.abs((tt1 - tt5)).toFixed(2) + "°C";
rows[i].cells[17].innerText = Math.abs((tt1 - dt)).toFixed(2) + "°C";
rows[i].cells[18].innerText = Math.abs((tt1 - promedio)).toFixed(2) + "°C";

/* Comparacion temperatura aire ensayo tt2 */
rows[i].cells[19].innerText = Math.abs((tt2 - tt3)).toFixed(2) + "°C";
rows[i].cells[20].innerText = Math.abs((tt2 - tt4)).toFixed(2) + "°C";
rows[i].cells[21].innerText = Math.abs((tt2 - tt5)).toFixed(2) + "°C";
rows[i].cells[22].innerText = Math.abs((tt2 - dt)).toFixed(2) + "°C";
rows[i].cells[23].innerText = Math.abs((tt2 - promedio)).toFixed(2) + "°C";

/* Comparacion temperatura aire ensayo tt3  */
rows[i].cells[24].innerText = Math.abs((tt3 - tt4)).toFixed(2) + "°C";
rows[i].cells[25].innerText = Math.abs((tt3 - tt5)).toFixed(2) + "°C";
rows[i].cells[26].innerText = Math.abs((tt3 - dt)).toFixed(2) + "°C";
rows[i].cells[27].innerText = Math.abs((tt3 - promedio)).toFixed(2) + "°C";

/* Comparacion temperatura aire ensayo tt4 */
rows[i].cells[28].innerText = Math.abs((tt4 - tt5)).toFixed(2) + "°C";
rows[i].cells[29].innerText = Math.abs((tt4 - dt)).toFixed(2) + "°C";
rows[i].cells[30].innerText = Math.abs((tt4 - promedio)).toFixed(2) + "°C";

/* Comparacion temperatura cercana a los patrones */
rows[i].cells[31].innerText = Math.abs((tt5 - dt)).toFixed(2) + "°C";
rows[i].cells[32].innerText = Math.abs((tt5 - promedio)).toFixed(2) + "°C";

/* Comparaciones Temperatura aire ensayo  */
rows[i].cells[33].innerText = Math.abs((tt1 - promedio)).toFixed(2) + "°C";
}

/* Calculamos variacion de las temperaturas por hora (Actual vs Anterior) no variar mas de 2°C */
for (let a = valores.length - 1; a > 0; a--){
  let celdaActual = parseFloat(rows[a].cells[10].innerText);
  let celdaAnterior = parseFloat(rows[a+1].cells[10].innerText);
  let resultado = celdaAnterior - celdaActual;
  rows[a].cells[11].innerText = resultado.toFixed(2) + "°C";
  rows[rows.length - 1].cells[11].textContent = "0.00";
}

/* Temperatura ambiente cada 12 horas no variar mas de 4°C */
let datoscolumna = [];
for (let e = 0; e < table.rows.length; e++){
  let textoanumero = table.rows[e].cells[10];
  datoscolumna.push(parseFloat(textoanumero.textContent));
}

let grupo = [];
let tamano = 12;
for (let b = 1; b < datoscolumna.length; b++){
  grupo.push(datoscolumna[b]);

  if (grupo.length === tamano){
    let max = Math.max(...grupo);
    let min = Math.min(...grupo);
    let promed = max - min;
    rows[b].cells[12].innerText = promed.toFixed(2) + "°C";
    grupo = [];
    }
  }
}
calculamosdatos();

/* Funcion para establecer colores para las temperaturas correctas e incorrectas */
function colores(){
/* Color temperatura promedios */
document.querySelectorAll('.Color-Temperatura-Promedio').forEach(td => {
  const colortemperaturapromedio = parseInt(td.textContent, 10);
  if (colortemperaturapromedio > 18 && colortemperaturapromedio < 23){
    td.classList.add('TemperaturaCorrecta');
  }else{
    td.classList.add('TemperaturaIncorrecta');
  }
});

/* Color temperatura cada hora */
document.querySelectorAll('.Color-Temperatura-Hora').forEach(td => {
  const colortemperaturahora = parseInt(td.textContent, 10);
  if (colortemperaturahora < 2){
    td.classList.add('TemperaturaCorrecta');
  }else if(isNaN(colortemperaturahora)){
    td.classList.add('CampoVacio');
  }else {
    td.classList.add('TemperaturaIncorrecta');
  }
});

/* Color temperatura cada doce horas */
document.querySelectorAll('.Color-Temperatura-Docehoras').forEach(td => {
  const colortemperaturadocehoras = parseInt(td.textContent, 10);
  if (colortemperaturadocehoras < 4){
    td.classList.add('TemperaturaCorrecta');
  }else if(isNaN(colortemperaturadocehoras)){
    td.classList.add('CampoVacio')
  }else {
    td.classList.add('TemperaturaIncorrecta');
  }
});

/* Color temperatura para comparaciones */
document.querySelectorAll('.Color-Temperatura-Comparaciones').forEach(td => {
  const colorcomparaciontemperaturas = parseInt(td.textContent, 10);
  if (colorcomparaciontemperaturas < .5){
    td.classList.add('TemperaturaCorrecta');
  }else {
    td.classList.add('TemperaturaIncorrecta');
  }
});
}

/* Datos globales para las graficas */
var graficapatron, graficaambiente, graficahumedad, graficarocio, graficapromedio, graficavariacioneshora, graficavariacionesdoce, graficacomparaciones, graficadatosmes, graficahumedadmes, graficavariacionesmes, graficacomparacionesmes;

/* Funcion para destruir graficas y ser reutilizables */
function destruirgraficas(){
  if (graficapatron) graficapatron.destroy();
  if (graficaambiente) graficaambiente.destroy();
  if (graficahumedad) graficahumedad.destroy();
  if (graficarocio) graficarocio.destroy();
  if (graficapromedio) graficapromedio.destroy();
  if (graficavariacioneshora) graficavariacioneshora.destroy();
  if (graficavariacionesdoce) graficavariacionesdoce.destroy();
  if (graficacomparaciones) graficacomparaciones.destroy();
  if (graficadatosmes) graficadatosmes.destroy();
  if (graficahumedadmes) graficahumedadmes.destroy();
  if (graficavariacionesmes) graficavariacionesmes.destroy();
  if (graficacomparacionesmes) graficacomparacionesmes.destroy();
}

/* Funcion para iniciar las graficas */
function iniciargraficas(){
const tabla = document.getElementById("datostemperaturas");
const rows = tabla.rows;

/* Datos registros y promedio */
const fechas = [];
const tt5 = [];
const temperatura = [];
const promedio = [];

/* Rocio */
const rocio = [];

/* Datos de humedad */
const humedad = [];

/* Datos de variaciones */
const hora = [];
const docehoras = [];

/* Datos de comparaciones */
const t1vst2 = [], t1vst3 = [], t1vst4 = [], t1vst5 = [], t1vstemp = [], t1vsprom = [];
const t2vst3 = [], t2vst4 = [], t2vst5 = [], t2vstemp = [], t2vsprom = [];
const t3vst4 = [], t3vst5 = [], t3vstemp = [], t3vsprom = [];
const t4vst5 = [], t4vstemp = [], t4vsprom = [];
const t5vstemp = [], t5vsprom = [], aire = [];

/* Recorrer los datos para ser graficados */
for (let i = 1; i < rows.length; i++){
fechas.push(rows[i].cells[0].innerText);
tt5.push(parseFloat(rows[i].cells[5].innerText));
temperatura.push(parseFloat(rows[i].cells[6].innerText));
promedio.push(parseFloat(rows[i].cells[10].innerText));
rocio.push(parseFloat(rows[i].cells[9].innerText));
humedad.push(parseFloat(rows[i].cells[7].innerText));
hora.push(parseFloat(rows[i].cells[11].innerText));
docehoras.push(parseFloat(rows[i].cells[12].innerText));
t1vst2.push(parseFloat(rows[i].cells[13].innerText));
t1vst3.push(parseFloat(rows[i].cells[14].innerText));
t1vst4.push(parseFloat(rows[i].cells[15].innerText));
t1vst5.push(parseFloat(rows[i].cells[16].innerText));
t1vstemp.push(parseFloat(rows[i].cells[17].innerText));
t1vsprom.push(parseFloat(rows[i].cells[18].innerText));
t2vst3.push(parseFloat(rows[i].cells[19].innerText));
t2vst4.push(parseFloat(rows[i].cells[20].innerText));
t2vst5.push(parseFloat(rows[i].cells[21].innerText));
t2vstemp.push(parseFloat(rows[i].cells[22].innerText));
t2vsprom.push(parseFloat(rows[i].cells[23].innerText));
t3vst4.push(parseFloat(rows[i].cells[24].innerText));
t3vst5.push(parseFloat(rows[i].cells[25].innerText));
t3vstemp.push(parseFloat(rows[i].cells[26].innerText));
t3vsprom.push(parseFloat(rows[i].cells[27].innerText));
t4vst5.push(parseFloat(rows[i].cells[28].innerText));
t4vstemp.push(parseFloat(rows[i].cells[29].innerText));
t4vsprom.push(parseFloat(rows[i].cells[30].innerText));
t5vstemp.push(parseFloat(rows[i].cells[31].innerText));
t5vsprom.push(parseFloat(rows[i].cells[32].innerText));
aire.push(parseFloat(rows[i].cells[33].innerText));
}

/* Grafica de temperatura por patrón */
var gftemperatura_patron = document.getElementById('grafica_temperatura_patron').getContext('2d');
const gftt5 ={
  label: 'Temperatura cercana a patrones',
  data: tt5,
  backgroundColor: 'rgba(255, 135, 0, 0.8)',
  borderColor: 'rgba(255, 135, 0, 0.8)',
  borderWidth: 1,
};

const limite_inferior_patron = {
  label: 'Limite inferior',
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)',
};

const limite_superior_patron = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)',
};

graficapatron = new Chart(gftemperatura_patron, {
type: 'line',
data: {
  labels: fechas, 
  datasets: [
    gftt5,
    limite_inferior_patron,
    limite_superior_patron
    ]
    },
    options: {
      scales: { 
        y: {
          min: 16,
          max: 24,
          ticks: {
            stepSize: 1,
            callback: function(value) {
              return value.toFixed(2) + "°C";
            }
            },
            grid: {
            color: function(context) {
            if (context.tick.value == 22) {
              return '#00ab05';
            } else if (context.tick.value == 18) {
              return '#e80000';
            }
              return '#a9a9a9';
            }
          }     
        }
      }
   }
});

/* Grafica de temperatura ambiente */
var gftemperatura_ambiente = document.getElementById('grafica_temperatura_ambiente').getContext('2d');     
const gftemperatura={
  label: "L.EM.THI-01 Temperatura ambiente cercana a los medidores a ensayar",
  data: temperatura,
  backgroundColor: 'rgba(77, 0, 255, 0.8)',
  borderColor: 'rgba(77, 0, 255, 0.8)',
  borderWidth: 1,
};

const limite_inferior_ambiente = {
  label: 'Limite inferior',
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)',
};

const limite_superior_ambiente = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)',
};

graficaambiente = new Chart(gftemperatura_ambiente, {
type: 'line',
data: {
  labels: fechas, 
  datasets: [
    gftemperatura,
    limite_inferior_ambiente,
    limite_superior_ambiente
    ]
    },
    options: {
      scales: { 
        y: {
          min: 16,
          max: 24,
          ticks: {
            stepSize: 1,
            callback: function(value) {
              return value.toFixed(2) + "°C";
            }
            },
            grid: {
            color: function(context) {
            if (context.tick.value == 22) {
              return '#00ab05';
            } else if (context.tick.value == 18) {
              return '#e80000';
            }
              return '#a9a9a9';
            }
          }     
        }
      }
   }
});

/* Grafica de humedad */
var gf_humedad = document.getElementById('grafica_humedad').getContext('2d');
const gfhumedad = {
  label: 'L.EM.THI-01 Humedad relativa',
  data: humedad,
  backgroundColor: 'rgba(0, 65, 215, 0.8)',
  borderColor: 'rgba(0, 65, 215, 0.8)',
  borderWidth: 1,
};

const lmhinferior = {
  label: "Limite inferior",
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)',
};

const lmhsuperior = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)',
};

graficahumedad = new Chart(gf_humedad, {
type: 'line',
data: {
  labels: fechas,
  datasets: [
    gfhumedad,
    lmhinferior,
    lmhsuperior
    ]
  },
options: {
  scales: {
    y: {
      min: 35.0,
      max: 85.0,
      grid: {
      color: function(context) {
        if (context.tick.value == 80) {
          return '#00ab05';
        } else if (context.tick.value == 40) {
          return '#e80000';
        }
          return '#a9a9a9';
        }
        },
        ticks: {
          callback: function(value) {
            return value.toFixed(1) + "% Hr";
          }
        },
      }
    }
  }
});

/* Grafica de rocio */
var gf_rocio = document.getElementById('grafica_rocio').getContext('2d');
const gfrocio ={
  label: 'Punto de rocio',
  data: rocio,
  backgroundColor: 'rgba(228, 0, 183, 0.8)',
  borderColor: 'rgba(228, 0, 183, 0.8)',
  borderWidth: 1,
  pointStyle: 'star',
  pointRadius: 6,
};

const lmrinferior = {
  label: "Limite inferior",
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)',
};
  
const lmrsuperior = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)',
};

graficarocio = new Chart(gf_rocio, {
  type: 'line',
  data: {
    labels: fechas,
    datasets: [
      gfrocio,
      lmrinferior,
      lmrsuperior
    ]
  },
  options: {
    scales: {
      y: {
        min: 0,
        max: 20,
        ticks: {
          stepSize: .5,
          callback: function(value) {
            return value.toFixed(2) + "°C";
          }
          },
          title: {
            display: true,
            text: 'Temperatura °C'
          },
          grid: {
            color: function(context) {
              if (context.tick.value == 18) {
                 return '#00ab05';
              } else if (context.tick.value == 5) {
                return '#e80000';
              }
                return '#a9a9a9';
            },
        }
      }
    }
  }
});

/* Grafica del promedio de las temperaturas */
var gf_promedio = document.getElementById('grafica_promedio').getContext('2d');
const gfpromedio ={
  label: 'Promedio temperatura ambiente cercana a los medidores a ensayar (TT1, TT2, TT3)',
  data: promedio,
  backgroundColor: 'rgba(9, 139, 0, 0.8)',
  borderColor: 'rgba(9, 139, 0, 0.8)',
  borderWidth: 1,
};

const lmpinferior = {
  label: 'Limite inferior',
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)',
};

const lmpsuperior = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)',
};

graficapromedio = new Chart(gf_promedio, {
  type: 'line',
  data: {
    labels: fechas,
    datasets: [
      gfpromedio,
      lmpinferior,
      lmpsuperior
    ]
  },
  options: {
    scales: {
      y: {
        min: 16,
        max: 24,
        ticks: {
          stepSize: 1,
          callback: function(value) {
            return value.toFixed(2) + "°C";
          }
          },
          grid: {
          color: function(context) {
          if (context.tick.value == 22) {
            return '#00ab05';
          } else if (context.tick.value == 18) {
            return '#e80000';
          }
            return '#a9a9a9';
          }
        }     
      }
    }
  }
});

/* Grafica de variación por hora */
var gf_variaciones_hora = document.getElementById('grafica_variacion_hora').getContext('2d');
const gfhora ={
  label: 'Temperatura ambiente promedio no varie mas de 2°C por hora',
  data: hora,
  backgroundColor: 'rgba(108, 27, 57, 1)',
  borderColor: 'rgba(108, 27, 57, 1)',
  borderWidth: 1,
};

const lmvinferior = {
  label: 'Limite inferior',
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)',
};

const lmvsuperior = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)',
};

graficavariacioneshora = new Chart(gf_variaciones_hora, {
type: 'line',
data: {
  labels: fechas,
  datasets: [
    gfhora,
    lmvinferior,
    lmvsuperior
  ]
},
options: {
  scales: {
    y: {
      min: -3.0,
      max: 3.0,
      text: 'Temperatura °C',
      ticks: {
        callback: function(value) {
          return value.toFixed(2) + "°C"
        }
        },
        title: {
          display: true,
          text: 'Temperatura °C'
        },
        grid: {
          color: function(context) {
            if (context.tick.value == 2) {
              return '#00ab05';
            } else if (context.tick.value == -2) {
              return '#e80000';
            }
              return '#a9a9a9';
            },
          }
        }
      }
    }
});

/* Grafica de variación cada 12 horas */
var gf_variaciones_doce = document.getElementById('grafica_variacion_doce').getContext('2d');    
const gfdocehoras ={
  label: 'Variación durante 12 horas no varie mas de 4°C',
  data: docehoras,
  backgroundColor: 'rgba(0, 177, 253, 1)',
  borderColor: 'rgba(0, 177, 253, 1)',
  borderWidth: 3,
  pointStyle: 'star',
  pointRadius: 6,
};

const lmtinferior = {
  label: 'Limite inferior',
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)',
};

const lmtsuperior = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)',
}

graficavariacionesdoce = new Chart(gf_variaciones_doce, {
type: 'line',
data: {
  labels: fechas,
  datasets: [
    gfdocehoras,
    lmtinferior,
    lmtsuperior
  ]
},
options: {
  scales: {
    y: {
      min: -5.0,
      max: 5.0,
      text: 'Temperatura °C',
      ticks: {
        callback: function(value) {
          return value.toFixed(2) + "°C"
        }
        },
        title: {
          display: true,
          text: 'Temperatura °C'
        },
        grid: {
          color: function(context) {
            if (context.tick.value == 4) {
              return '#00ab05';
            } else if (context.tick.value == -4) {
              return '#e80000';
            }
              return '#a9a9a9';
            },
          }
        }
      }
    }
});

/* Tomamos los datos de la tabla para las comparaciones */
const comparativas = {
  set1: t1vst2,
  set2: t1vst3,
  set3: t1vst4,
  set4: t1vst5,
  set5: t1vstemp,
  set6: t1vsprom,
  set7: t2vst3,
  set8: t2vst4,
  set9: t2vst5,
  set10: t2vstemp,
  set11: t2vsprom,
  set12: t3vst4,
  set13: t3vst5,
  set14: t3vstemp,
  set15: t3vsprom,
  set16: t4vst5,
  set17: t4vstemp,
  set18: t4vsprom,
  set19: t5vstemp,
  set20: t5vsprom,
  set21: aire
}

/* Grafica de comparación de las temperaturas */
var gf_comparaciones = document.getElementById('grafica_comparaciones').getContext('2d');
const cp21inferior = {
  label: 'Limite inferior',
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)'
};

const cp21superior = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)'
};

graficacomparaciones = new Chart(gf_comparaciones, {
  type: 'line',
  data: {
    labels: fechas,
    datasets: [{
      label: 'Comparación',
      data: comparativas.set1,
      backgroundColor: [
        'rgba(0, 65, 215, 0.8)'
    ],
    borderColor: [
        'rgba(0, 65, 215, 0.8)'
    ],
    borderWidth: 1
  },
  cp21inferior,
  cp21superior
    ]
  },
  options: {
    interaction: {
        mode: 'index',
        intersect: false
      },
      scales: {
        y: {
          min: -3,
          max: 3,
          grid: {
            color: function(context) {
              if (context.tick.value == 2) {
                return '#00ab05';
              } else if (context.tick.value == -2) {
                return '#e80000';
              }
                return '#a9a9a9';
            }
          },
          ticks: {
            callback: function(value) {
               return value.toFixed(2)
            }
          },
            title: {
              display: true,
              text: 'Temperatura °C'
          }
      }
    }
  }
});

/* Función para actualizar los datos de las comparaciones */
function actualizarcomparacion(set) {
  const dataset = comparativas[set];
  if (dataset) {
    graficacomparaciones.data.datasets[0].data = dataset;
    graficacomparaciones.update();
  } else {
    console.log("Conjunto de datos no encontrado:", set);
  }
}

/* Función para asigar una comparacion a cada botón */
function asignarBotones() {
  document.getElementById('comp1').addEventListener('click', () => actualizarcomparacion('set1'));
  document.getElementById('comp2').addEventListener('click', () => actualizarcomparacion('set2'));
  document.getElementById('comp3').addEventListener('click', () => actualizarcomparacion('set3'));
  document.getElementById('comp4').addEventListener('click', () => actualizarcomparacion('set4'));
  document.getElementById('comp5').addEventListener('click', () => actualizarcomparacion('set5'));
  document.getElementById('comp6').addEventListener('click', () => actualizarcomparacion('set6'));
  document.getElementById('comp7').addEventListener('click', () => actualizarcomparacion('set7'));
  document.getElementById('comp8').addEventListener('click', () => actualizarcomparacion('set8'));
  document.getElementById('comp9').addEventListener('click', () => actualizarcomparacion('set9'));
  document.getElementById('comp10').addEventListener('click', () => actualizarcomparacion('set10'));
  document.getElementById('comp11').addEventListener('click', () => actualizarcomparacion('set11'));
  document.getElementById('comp12').addEventListener('click', () => actualizarcomparacion('set12'));
  document.getElementById('comp13').addEventListener('click', () => actualizarcomparacion('set13'));
  document.getElementById('comp14').addEventListener('click', () => actualizarcomparacion('set14'));
  document.getElementById('comp15').addEventListener('click', () => actualizarcomparacion('set15'));
  document.getElementById('comp16').addEventListener('click', () => actualizarcomparacion('set16'));
  document.getElementById('comp17').addEventListener('click', () => actualizarcomparacion('set17'));
  document.getElementById('comp18').addEventListener('click', () => actualizarcomparacion('set18'));
  document.getElementById('comp19').addEventListener('click', () => actualizarcomparacion('set19'));
  document.getElementById('comp20').addEventListener('click', () => actualizarcomparacion('set20'));
  document.getElementById('comp21').addEventListener('click', () => actualizarcomparacion('set21'));
}asignarBotones();

/* ----------  GRAFICAS PARA ANÁLISIS  ---------- */
/* Grafica de temperaturas, promedio y rocio del mes */    
if (document.body.getAttribute('data-page') === 'pagina_analisis') {  /* Solo se ejecutara en la pagina de analisis del mes */  
var gfdatos_promedio_mes = document.getElementById('grafica_temperaturas_promedio_mes').getContext('2d');
const gftt5m ={
  label: 'Temperatura cercana a patrones',
  data: tt5,
  backgroundColor: 'rgba(255, 135, 0, 0.8)',
  borderColor: 'rgba(255, 135, 0, 0.8)',
  borderWidth: 1,
};
          
const gftemperaturam={
  label: "L.EM.THI-01 Temperatura ambiente cercana a los medidores a ensayar",
  data: temperatura,
  backgroundColor: 'rgba(77, 0, 255, 0.8)',
  borderColor: 'rgba(77, 0, 255, 0.8)',
  borderWidth: 1,
};

const gfpromediom ={
  label: 'Promedio temperatura ambiente cercana a los medidores a ensayar (TT1, TT2, TT3)',
  data: promedio,
  backgroundColor: 'rgba(9, 139, 0, 0.8)',
  borderColor: 'rgba(9, 139, 0, 0.8)',
  borderWidth: 1,
};

const gfrociom ={
  label: 'Punto de rocio',
  data: rocio,
  backgroundColor: 'rgba(228, 0, 183, 0.8)',
  borderColor: 'rgba(228, 0, 183, 0.8)',
  borderWidth: 1,
  pointStyle: 'star',
  pointRadius: 6,
};

const lmdinferior = {
  label: 'Limite inferior',
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)',
};

const lmdsuperior = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)',
};

graficadatosmes = new Chart(gfdatos_promedio_mes, {
type: 'line',
data: {
  labels: fechas, 
  datasets: [
    gftt5m,
    gftemperaturam,
    gfpromediom,
    gfrociom,
    lmdinferior,
    lmdsuperior
    ]
    },
    options: {
      scales: { 
        y: {
          min: 6,
          max: 24,
          ticks: {
            stepSize: 1,
            callback: function(value) {
              return value.toFixed(2) + "°C";
            }
            },
            grid: {
            color: function(context) {
            if (context.tick.value == 22) {
              return '#00ab05';
            } else if (context.tick.value == 18) {
              return '#e80000';
            }
              return '#a9a9a9';
            }
          }     
        }
      }
   }
});

/* Grafica de humedad para análisis del mes */
var gf_humedad_mes = document.getElementById('grafica_humedad_mes').getContext('2d');
const gfhumedadm = {
  label: 'L.EM.THI-01 Humedad relativa',
  data: humedad,
  backgroundColor: 'rgba(0, 65, 215, 0.8)',
  borderColor: 'rgba(0, 65, 215, 0.8)',
  borderWidth: 1,
};
        
const lmhminferior = {
  label: "Limite inferior",
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)',
};
        
const lmhmsuperior = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)',
};

graficahumedadmes = new Chart(gf_humedad_mes, {
type: 'line',
data: {
  labels: fechas,
  datasets: [
    gfhumedadm,
    lmhminferior,
    lmhmsuperior
  ]
},
options: {
  scales: {
    y: {
      min: 35.0,
      max: 85.0,
      grid: {
      color: function(context) {
        if (context.tick.value == 80) {
          return '#00ab05';
        } else if (context.tick.value == 40) {
          return '#e80000';
        }
          return '#a9a9a9';
        }
        },
        ticks: {
          callback: function(value) {
            return value.toFixed(1) + "% Hr";
        }
      },
    }
  }
}
});

/* Grafic de variaciones de una y doce horas para análisis del mes */
var gf_variaciones_mes = document.getElementById('grafica_variaciones_mes').getContext('2d');
const gfhoram ={
  label: 'Temperatura ambiente promedio no varie mas de 2°C por hora',
  data: hora,
  backgroundColor: 'rgba(108, 27, 57, 1)',
  borderColor: 'rgba(108, 27, 57, 1)',
  borderWidth: 1,
};
        
const gfdocehorasm ={
  label: 'Variación durante 12 horas no varie mas de 4°C',
  data: docehoras,
  backgroundColor: 'rgba(0, 177, 253, 1)',
  borderColor: 'rgba(0, 177, 253, 1)',
  borderWidth: 3,
  pointStyle: 'star',
  pointRadius: 6,
};
        
const lmvminferior = {
  label: 'Limite inferior no varia mas de 2°c por hora',
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)',
};
        
const lmvmsuperior = {
  label: 'Limite superior no varia mas de 2°C por hora',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)',
};
        
const lmtminferior = {
  label: 'Limite inferior no varie mas de 4°C cada 12 horas',
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)'
};
        
const lmtmsuperior = {
  label: 'Limite superior no varie mas de 4°C cada 12 horas',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)'
}

graficavariacionesmes = new Chart(gf_variaciones_mes, {
type: 'line',
data: {
  labels: fechas,
  datasets: [
    gfhoram,
    gfdocehorasm,
    lmvminferior,
    lmvmsuperior,
    lmtminferior,
    lmtmsuperior
  ]
},
options: {
  scales: {
    y: {
      min: -5,
      max: 5,
      text: 'Temperatura °C',
      ticks: {
        stepSize: .5,
        callback: function(value) {
          return value.toFixed(2) + "°C"
        }
        },
        title: {
          display: true,
          text: 'Temperatura °C'
        },
        grid: {
          color: function(context) {
            if (context.tick.value == 4) {
               return '#00ab05';
            } else if (context.tick.value == -4) {
              return '#e80000';
            } else if (context.tick.value == 2) {
              return '#00ab05';
            } else if (context.tick.value == -2) {
              return '#e80000';
            }
              return '#a9a9a9';
          },
      }
    }
  }
}
});

/* Grafica para comparacion de temperaturas durante el mes para análisis */
var gf_comparaciones_mes = document.getElementById('grafica_comparaciones_mes').getContext('2d');
const com_t1vst2 ={
  label: "TT1 VS TT2",
  data: t1vst2,
  backgroundColor: 'rgba(255, 93, 0, 1)',
  borderColor: 'rgba(255, 93, 0, 1)',
  borderWidth: 1,
};

const com_t1vst3 ={
  label: "TT1 VS TT3",
  data: t1vst3,
  backgroundColor: 'rgba(255, 215, 0, 1)',
  borderColor: 'rgba(255, 215, 0, 1)',
  borderWidth: 1,
};

const com_t1vst4 ={
  label: "TT1 VS TT4",
  data: t1vst4,
  backgroundColor: 'rgba(125, 255, 0, 1)',
  borderColor: 'rgba(125, 255, 0, 1)',
  borderWidth: 1,
};

const com_t1vst5 ={
  label: "TT1 VS TT5",
  data: t1vst5,
  backgroundColor:  'rgba(0, 255, 183, 1)',
  borderColor: 'rgba(0, 255, 183, 1)',
  borderWidth: 1,
};

const com_t1vstemp ={
  label: "TT1 VS Temperatura ambiente",
  data: t1vstemp,
  backgroundColor: 'rgba(0, 104, 255, 1)',
  borderColor: 'rgba(0, 104, 255, 1)',
  borderWidth: 1,
};

const com_t1vsprom ={
  label: "TT1 VS Promedio",
  data: t1vsprom,
  backgroundColor: 'rgba(98, 0, 255, 1)',
  borderColor: 'rgba(98, 0, 255, 1)',
  borderWidth: 1,
};

const com_t2vst3 ={
  label: "TT2 VS TT3",
  data: t2vst3,
  backgroundColor: 'rgba(255, 0, 226, 1)',
  borderColor: 'rgba(255, 0, 226, 1)',
  borderWidth: 1,
};

const com_t2vst4 ={
  label: "TT2 VS TT4",
  data: t2vst4,
  backgroundColor: 'rgba(255, 153, 153, 1)',
  borderColor: 'rgba(255, 153, 153, 1)',
  borderWidth: 1,
};

const com_t2vst5 ={
  label: "TT2 VS TT5",
  data: t2vst5,
  backgroundColor: 'rgba(244, 94, 94, 1)',
  borderColor: 'rgba(244, 94, 94, 1)',
  borderWidth: 1,
};

const com_t2vstemp ={
  label: "TT2 VS Temperatura ambiente",
  data: t2vstemp,
  backgroundColor: 'rgba(130, 120, 26, 1)',
  borderColor: 'rgba(130, 120, 26, 1)',
  borderWidth: 1,
};

const com_t2vsprom ={
  label: "TT2 VS Promedio",
  data: t2vsprom,
  backgroundColor: 'rgba(33, 130, 26, 1)',
  borderColor: 'rgba(33, 130, 26, 1)',
  borderWidth: 1,
};

const com_t3vst4 ={
  label: "TT3 VS TT4",
  data: t3vst4,
  backgroundColor: 'rgba(130, 26, 26, 1)',
  borderColor: 'rgba(130, 26, 26, 1)',
  borderWidth: 1,
};

const com_t3vst5 ={
  label: "TT3 VS TT5",
  data: t3vst5,
  backgroundColor: 'rgba(18, 72, 51, 1)',
  borderColor: 'rgba(18, 72, 51, 1)',
  borderWidth: 1,
};

const com_t3vstemp ={
  label: "TT3 VS Temperatura ambiente",
  data: t3vstemp,
  backgroundColor: 'rgba(144, 138, 194, 1)',
  borderColor: 'rgba(144, 138, 194, 1)',
  borderWidth: 1,
};

const com_t3vsprom ={
  label: "TT3 VS Promedio",
  data: t3vsprom,
  backgroundColor: 'rgba(55, 157, 60, 0.77)',
  borderColor: 'rgba(55, 157, 60, 0.77)',
  borderWidth: 1,
};

const com_t4vst5 ={
  label: "TT4 VS TT5",
  data: t4vst5,
  backgroundColor: 'rgba(80, 95, 18, 1)',
  borderColor: 'rgba(80, 95, 18, 1)',
  borderWidth: 1,
};

const com_t4vstemp ={
  label: "TT4 VS Temperatura ambiente",
  data: t4vstemp,
  backgroundColor: 'rgba(23, 18, 95, 1)',
  borderColor: 'rgba(23, 18, 95, 1)',
  borderWidth: 1,
};

const com_t4vsprom ={
  label: "TT4 VS Promedio",
  data: t4vsprom,
  backgroundColor: 'rgba(95, 18, 18, 1)',
  borderColor: 'rgba(95, 18, 18, 1)',
  borderWidth: 1,
};

const com_t5vstemp ={
  label: "TT5 VS Temperatura ambiente",
  data: t5vstemp,
  backgroundColor: 'rgba(64, 102, 113, 1)',
  borderColor: 'rgba(64, 102, 113, 1)',
  borderWidth: 1,
};

const com_t5vsprom ={
  label: "TT5 VS Promedio",
  data: t5vsprom,
  backgroundColor: 'rgba(0, 0, 0, 1)',
  borderColor: 'rgba(0, 0, 0, 1)',
  borderWidth: 1,
};

const com_aire ={
  label: "Temperatura Aire (TT5) <= 0.5 °C",
  data: aire,
  backgroundColor: 'rgba(255, 183, 116, 1)',
  borderColor: 'rgba(255, 183, 116, 1)',
  borderWidth: 1,
};

const lmcinferior = {
  label: 'Limite inferior',
  backgroundColor: 'rgba(255, 0, 0, 0.8)',
  borderColor: 'rgba(255, 0, 0, 0.8)'
};

const lmcsuperior = {
  label: 'Limite superior',
  backgroundColor: 'rgba(29, 255, 0, 0.8)',
  borderColor: 'rgba(29, 255, 0, 0.8)'
};

graficacomparacionesmes = new Chart(gf_comparaciones_mes, {
type: 'line',
data: {
  labels: fechas,
  datasets: [
    com_t1vst2,
    com_t1vst3,
    com_t1vst4,
    com_t1vst5,
    com_t1vstemp,
    com_t1vsprom,
    com_t2vst3,
    com_t2vst4,
    com_t2vst5,
    com_t2vstemp,
    com_t2vsprom,
    com_t3vst4,
    com_t3vst5,
    com_t3vstemp,
    com_t3vsprom,
    com_t4vst5,
    com_t4vstemp,
    com_t4vsprom,
    com_t5vstemp,
    com_t5vsprom,
    com_aire,
    lmcinferior,
    lmcsuperior
    ]
},
  options: {
    interaction: {
      mode: 'index',
      intersect: false
    },
    scales: {
      y: {
        min: -3,
        max: 3,
        grid: {
          color: function(context) {
            if (context.tick.value == 2) {
              return '#00ab05';
            } else if (context.tick.value == -2) {
              return '#e80000';
            }
              return '#a9a9a9';
          }
        },
        ticks: {
          callback: function(value) {
             return value.toFixed(2) + "°C"
          }
        },
        title: {
          display: true,
          text: 'Temperatura °C'
        }
      }
    }
  }
});
}
}iniciargraficas();

/* Cargar y actualizar graficas */
function actualizargrafica() {
  destruirgraficas();
  iniciargraficas();
}