<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Condiciones Ambientales</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
  <link rel="stylesheet" type="text/css" href="../../css/estilos.css">
  <link rel="stylesheet" type="text/css" href="../../css/footable.standalone.min.css">
  <link rel="manifest" href="../../manifest.json">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body onload="mostrarReloj()" data-page="pagina_analisis">
<header id="main-header">
<a id="logo-header">
	<img src="../../img/Logo-Laboratorio.png"> 
</a>
<nav>
<div id="datos">
 <ul>
   <li><a href="../analisis_por_mes/analisis_mes.php">Análisis por Mes</a></li>
   <li><a href="../analisis_rango_fechas/analisis_rango.php">Análisis por Rango de Fechas</a></li>
   <li><a href="#" id="nosotros">Nosotros</a></li>
 </ul>
</div>
</nav>

<!-- Reloj -->
<nav>
<div id="mostrardatos">
  <div class="fondoreloj">
    <div id="hora"></div>
    <div id="calendario"></div>
  </div>
</div>
</nav>
</header><br>

<h1>Condiciones Ambientales B-Sonic</h1>

<!-- Formulario para ingresar -->
<form id="formularioguardar">
<fieldset>
<legend>Agregar nuevos datos</legend>
<div class="form-control">
  <label>TT1 Temperatura de aire para ensayo: </label>
  <input type="number" step="any" name="tt1" id="tt1" placeholder="Temperatura °C" autocomplete="off" required/>
</div>

<div class="form-control">
  <label>TT2 Aire de medidores a ensayar: </label>
  <input type="number" step="any" name="tt2" id="tt2" placeholder="Temperatura °C" autocomplete="off" required/>
</div>

<div class="form-control">
  <label>TT3 Aire de medidores a ensayar: </label>
  <input type="number" step="any" name="tt3" id="tt3" placeholder="Temperatura °C" autocomplete="off" required/>
</div>

<div class="form-control">
  <label>TT4 Aire de medidores a ensayar: </label>
  <input type="number" step="any" name="tt4" id="tt4" placeholder="Temperatura °C" autocomplete="off" required/>
</div>

<div class="form-control">
  <label>TT5 Temperatura cercana a patrones: </label>
  <input type="number" step="any" name="tt5" id="tt5" placeholder="Temperatura °C" autocomplete="off" required/>
</div>

<div class="form-control">
  <label>LEM THI-01 Temperatura ambiente cercana a medidores a ensayar: </label>
  <input type="number" step="any" name="temperatura" id="temperatura" placeholder="Temperatura °C" autocomplete="off" required/>
</div>

<div class="form-control">
  <label>LEM THI-01 Humedad relativa: </label>
  <input type="number" step="any" name="humedad" id="humedad" placeholder="Humedad Relativa (%)" autocomplete="off" required/>
</div>

<div class="form-control">
  <label>LEM BAR-01 Presión atmosférica: </label>
  <input type="number" step="any" name="presion" id="presion" placeholder="Presión Atmosférica" autocomplete="off" required/>
</div>
<br>
<button type="submit" name="guardar" id="guardar" class="btn btn-primary" onclick="guardar_datos()">Guardar Datos</button>
</fieldset>
</form><br>

<h1>Tabla de los últimos 24 datos ingresados: </h1>

<!-- Botón para ver graficas de las temperaturas acumuladas de los ultimos 24 datos guardados -->
<div class="d-grid gap-2 col-11 justify-content-md-end">
<button type="button" class="btn btn-primary btn-lg" data-bs-target="#modal_graficas_ultimos_registros" data-bs-toggle="modal">Ver Graficas Apiladas</button>
</div><br>

<!-- Contenido de la Tabla -->
<div class="table-scroll">
<table id="datostemperaturas" class="tabledata">
</table>
</div>

<!-- Modal Temperatura cercana a los patrones -->
<div class="modal fade bd-example-modal-lg" id="graficatemperaturapatron" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">TT5 Temperatura cercana a los patrones de los ultimos 24 datos</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_temperatura_patron"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal Temperatura ambiente -->
<div class="modal fade bd-example-modal-lg" id="graficatemperaturaambiente" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">LEM THI-01 Temperatura ambiente cercana a medidores a ensayar de los ultimos 24 datos</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_temperatura_ambiente"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal Humedad -->
<div class="modal fade bd-example-modal-lg" id="graficahumedad" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Humedad relativa de los ultimos 24 datos</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_humedad"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal Rocio -->
<div class="modal fade bd-example-modal-lg" id="graficarocio" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Datos de rocio de los ultimos 24 datos</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_rocio"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal promedio de temperaturas -->
<div class="modal fade bd-example-modal-lg" id="graficapromedio" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Promedios de los ultimos 24 datos</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_promedio"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal variaciones cada hora -->
<div class="modal fade bd-example-modal-lg"  id="graficavariacionhora" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Variaciones por hora de las temperaturas en los ultimos 24 datos</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_variacion_hora"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal variaciones cada 12 horas -->
<div class="modal fade bd-example-modal-lg"  id="graficavariaciondoce" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Variaciones cada 12 horas de las temperaturas en los ultimos 24 datos</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_variacion_doce"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal de comparacion de temperaturas -->
<div class="modal fade bd-example-modal-lg" id="modalcomparaciones" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Comparaciones de las temperaturas de los ultimos 24 datos</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_comparaciones"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal Graficas Apiladas -->
<div class="modal fade" id="modal_graficas_ultimos_registros" tabindex="-1" aria-labelledby="modal1Label" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modal1Label">Gráficas de las temperaturas de los ultimos 24 datos registrados</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="container-fluid">
         <div class="row">
           <div class="col-md-4">
            <h5>Gráfica Temperaturas ingresadas, promedio y rocio</h5>
           <div class="chart-container">
            <canvas id="grafica_temperaturas_promedio_mes"></canvas>
            </div>
           </div>
           <div class="col-md-6 ms-auto">
            <h5>Gráfica de Humedad</h5>
            <div class="chart-container">
            <canvas id="grafica_humedad_mes"></canvas>
            </div>
           </div>
         </div>
         <div class="row">
           <div class="col-md-4">
            <h5>Gráfica Variaciones por hora y doce hora</h5>
            <div class="chart-container">
            <canvas id="grafica_variaciones_mes"></canvas>
            </div>
           </div>
           <div class="col-md-6 ms-auto">
            <h5>Gráfica de comparaciones de las temperaturas</h5>
            <div class="chart-container">
            <canvas id="grafica_comparaciones_mes"></canvas>
            </div>
           </div>
         </div>
       </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal historico versionamiento -->
<div class="modal fade" id="versioneslab" tabindex="-1" aria-labelledby="modal1Label" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modal1Label">Versiones</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <table id="versiones_guardadas" class="table" data-paging="true" data-empty="No hay resultados"></table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="añadirversion">Añadir versión</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal añadir version -->
<div class="modal fade" id="modal_versiones" tabindex="-1" aria-labelledby="modal2Label" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modal2Label">Ingresar información sobre nueva Versión</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
      <form id="formularioversion">
        <div class="mb-3">
          <label class="col-form-label">Versión:</label>
          <input class="form-control" type="number" step="any" name="versiones" id="versiones" placeholder="Versión" autocomplete="off" required/>
        </div>
        <div class="mb-3">
          <label class="col-form-label">Descripción:</label>
          <textarea class="form-control" name="descripcion" id="descripcion" placeholder="Especificaciones sobre la nueva versión" autocomplete="off" required></textarea>
        </div>
        <button type="submit" class="btn btn-primary" onclick="guardar_version()">Guardar</button>
      </form>
      </div>
    </div>
  </div>
</div>
<!-- Mostrar modales de versión y guardar versión al tiempo -->
<script>
const abrirmodalversion = document.getElementById('añadirversion');
abrirmodalversion.addEventListener('click', function() {
var modal_versiones = new bootstrap.Modal(document.getElementById('modal_versiones'), {
});
modal_versiones.show();
});
var versioneslab = document.getElementById('versioneslab');
versioneslab.addEventListener('hide.bs.modal', function (event) {
});
</script>

<!--Footer--> 
<div class="footer"><span> Realizado por el Departamento Digital e Innovación </span></div>
<div class="footer"><span> MayunLab </span> &copy;<span> 2024 </span> <span>  |  Versión 1.00 <a href="" data-bs-toggle="modal" data-bs-target="#versioneslab" onclick="mostrar_versiones()">  Sobre las versiones</a></span></div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/moment.js/2.10.3/moment.min.js"></script>
<script src="../../js/footable.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous"></script>
<script src="../../js/script.js"></script>
</body>
</html>