<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Condiciones Ambientales</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
  <link rel="stylesheet" type="text/css" href="../../css/estilos.css">
  <link href="../../css/footable.standalone.min.css" rel="stylesheet">
  <link rel="manifest" href="../../manifest.json">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body onload="mostrarReloj()" data-page="pagina_analisis">
<header id="main-header">
<a id="logo-header">
	<img src="../../img/Logo-Laboratorio.png"> 
</a>
<nav>
<div id="datos">
<ul>
  <li><a href="../index/index.php">Inicio</a></li>
  <li><a href="../analisis_por_mes/analisis_mes.php">Análisis por Mes</a></li>
  <li><a id="nosotros"></a></li>
</ul>
</div>
</nav>

<!-- Reloj -->
<nav>
<div id="mostrardatos">
  <div class="fondoreloj">
    <div id="hora"></div>
    <div id="calendario"></div>
  </div>
  </div>
</nav>
</header><br>

<h1>Temperaturas por Rango de Fechas</h1>
<!-- Análisis por rango de fechas -->
<div class="buscar">
  <h3> Seleccione un rango de fechas para buscar: </h3>
  <form id="form-fechas" class="row g-3" method="post">
    <div class="col-auto">
      <label for="fecha_inicio">Fecha Inicial: </label>
      <input type="date" id="fecha_inicio" name="fecha_inicio" required>
    </div>
    <div class="col-auto">
      <label for="fecha_final">Fecha Final: </label>
      <input type="date" id="fecha_final" name="fecha_final" required>
    </div>
    <div>
      <button type="button" class="btn btn-primary mb-3" onclick="buscar_analisis_rango_fechas()">Buscar</button>
    </div>
  </form>
</div><br>

<!-- Botón para ver análisis guardados -->
<div class="d-grid gap-2 col-7 justify-content-md-end">
<button type="button" class="btn btn-primary btn-lg" data-bs-target="#ver_analisis_periodico" onclick="mostrar_analisis_rango()" data-bs-toggle="modal">Análisis registrados</button>
</div>

<!-- Botón para ver graficas del mes y generar un analisis -->
<div class="d-grid gap-2 col-3 justify-content-md-end">
<button type="button" class="btn btn-primary btn-lg" data-bs-target="#modal_graficas_apiladas" data-bs-toggle="modal">Generar análisis</button>
</div>

<!-- Contenido de la tabla -->
<div class="table-scroll"> 
<table id="datostemperaturas" class="tabledata">
</table>
</div>

<!-- Modal Temperatura cercana a los patrones -->
<div class="modal fade bd-example-modal-lg" id="graficatemperaturapatron" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">TT5 Temperatura cercana a los patrones</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_temperatura_patron"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal Temperatura ambiente -->
<div class="modal fade bd-example-modal-lg" id="graficatemperaturaambiente" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">LEM THI-01 Temperatura ambiente cercana a medidores a ensayar</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_temperatura_ambiente"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal Humedad -->
<div class="modal fade bd-example-modal-lg" id="graficahumedad" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Humedad relativa</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_humedad"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal Rocio -->
<div class="modal fade bd-example-modal-lg" id="graficarocio" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Punto de rocio</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_rocio"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal promedio de temperaturas -->
<div class="modal fade bd-example-modal-lg" id="graficapromedio" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Promedio de las temperaturas</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_promedio"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal variaciones cada hora -->
<div class="modal fade bd-example-modal-lg"  id="graficavariacionhora" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Variaciones por hora no sea mayor a 2°C</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_variacion_hora"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal variaciones cada 12 horas -->
<div class="modal fade bd-example-modal-lg"  id="graficavariaciondoce" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Variaciones cada 12 horas no sea mayor a 4°C</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_variacion_doce"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal de comparacion de temperaturas -->
<div class="modal fade bd-example-modal-lg" id="modalcomparaciones" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Comparaciones de las temperaturas</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <canvas id="grafica_comparaciones"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Modal para mostrar graficas para el análsis periodico -->
<div class="modal fade" id="modal_graficas_apiladas" tabindex="-1" aria-labelledby="modal1Label" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modal1Label">Gráficas de las temperaturas durante las fechas seleccionadas</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="container-fluid">
         <div class="row">
           <div class="col-md-4">
            <h5>Gráfica Temperaturas ingresadas, promedio y rocio</h5>
           <div class="chart-container">
            <canvas id="grafica_temperaturas_promedio_mes"></canvas>
            </div>
           </div>
           <div class="col-md-6 ms-auto">
            <h5>Gráfica de Humedad</h5>
            <div class="chart-container">
            <canvas id="grafica_humedad_mes"></canvas>
            </div>
           </div>
         </div>
         <div class="row">
           <div class="col-md-4">
            <h5>Gráfica Variaciones por hora y doce hora</h5>
            <div class="chart-container">
            <canvas id="grafica_variaciones_mes"></canvas>
            </div>
           </div>
           <div class="col-md-6 ms-auto">
            <h5>Gráfica de comparaciones de las temperaturas</h5>
            <div class="chart-container">
            <canvas id="grafica_comparaciones_mes"></canvas>
            </div>
           </div>
         </div>
       </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="modalanalisis">Crear Análisis</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal Guardar Análisis por rango de fechas -->
<div class="modal fade" id="modal_analisis_rango" tabindex="-1" aria-labelledby="modal2Label" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modal2Label">Crear Análisis</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="formularioanalisisrango">
          <div class="mb-3">
            <label class="col-form-label">Nombre:</label>
            <input type="text" class="form-control" name="nombre" id="nombre" placeholder="Nombre" autocomplete="off" required>
          </div>
          <div class="mb-3">
            <label class="col-form-label">Cargo:</label>
            <input type="text" class="form-control" name="cargo" id="cargo" placeholder="Cargo" autocomplete="off" required>
          </div>
          <div class="mb-3">
            <label class="col-form-label" require>Análisis:</label>
            <textarea class="form-control" name="analisis" id="analisis" placeholder="Descripción del análisis" required></textarea>
          </div>
          <button type="submit" class="btn btn-primary" onclick="guardar_analisis_rango()">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>
<!-- Mostrar los modales de graficas y analisis al tiempo -->
<script>
const abrirmodalanalisis = document.getElementById('modalanalisis');
  abrirmodalanalisis.addEventListener('click', function() {
var modal_analisis_rango = new bootstrap.Modal(document.getElementById('modal_analisis_rango'), {});
  modal_analisis_rango.show();
});
var modal_graficas_apiladas = document.getElementById('modal_graficas_apiladas');
  modal_graficas_apiladas.addEventListener('hide.bs.modal', function (event) {
});
</script>

<!-- Ver análisis por rango de fechas guardados -->
<div class="modal fade" id="ver_analisis_periodico" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-scrollable modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5">Análisis Registrados</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
      <div class="mb-3">
        <label class="col-form-label">Fecha inicial: </label>
        <input type="date" id="busqueda_fecha_inicio">
        <label class="col-form-label">Fecha final: </label>
        <input type="date" id="busqueda_fecha_final">
      </div>
      <div class="mb-3">
      <button type="button" class="btn btn-primary" onclick="filtrar_rango()">Buscar análisis</button>
      </div>
      </form>
      <h3>Análisis Generados</h3>
      <div>
        <center><table id="resultados_analisis_rango" class="table" data-paging="true" data-empty="No se encontraron análisis"></table><center>
      </div>
      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/moment.js/2.10.3/moment.min.js"></script>
<script src="../../js/footable.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous"></script>
<script src="../../js/script.js"></script>
</body>
</html>